<?php
/**
 * Shortcodes
 *
 * @package     AutomatorWP\Button\Shortcodes
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * [automatorwp_button]
 *
 * @since 1.0.0
 *
 * @param array     $atts       Shortcode's attributes
 * @param string    $content    Shortcode's content
 *
 * @return string
 */
function automatorwp_button_shortcode( $atts = array(), $content = '' ) {

    global $post;

    // Get the received shortcode attributes
    $atts = shortcode_atts( array(
        'trigger'   => '',
        'label'     => __( 'Click me!', 'automatorwp-pro' ),
        'id'        => '',
        'class'     => '',
        'onclick'   => ''
    ), $atts, 'automatorwp_button' );

    $post_id = ( $post ? $post->ID : 0 );

    ob_start(); ?>
    <button type="button"
            data-trigger="<?php echo esc_attr( $atts['trigger'] ); ?>"
            id="<?php echo esc_attr( $atts['id'] ); ?>"
            class="automatorwp-button <?php echo esc_attr( $atts['class'] ); ?>"
            onclick="<?php echo esc_attr( $atts['onclick'] ); ?>"
            data-post="<?php echo esc_attr( $post_id ); ?>"
    ><?php echo $atts['label']; ?></button>
    <?php $output = ob_get_clean();

    // Return the shortcode output
    return $output;

}
add_shortcode( 'automatorwp_button', 'automatorwp_button_shortcode' );